// PrinterSettings.cpp : implementation file
//

#include "stdafx.h"
#include "afxdialogex.h"
#include "windows.h"
#include "DTC_C++Demo.h"
#include "MainSheet.h"
#include "PrinterSettings.h"
#include "Infopage.h"
#include "Encoding.h"
#include "DriverSettings1.h"
#include "DriverSettings2.h"
#include "PrintDemo.h"

//#############################################################################

// CPrinterSettings dialog

IMPLEMENT_DYNAMIC(CPrinterSettings, CPropertyPage)

CPrinterSettings::CPrinterSettings()
	: CPropertyPage(CPrinterSettings::IDD)
	, PrinterAction(0)
{
	//Create other tab pages
	InfoPage	 = new CInfoPage;
	EncodingPage = new CEncoding;
	DriverPage1  = new CDriverSettings1;
	DriverPage2  = new CDriverSettings2;
	PrintPage	 = new CPrintDemo;
	UtilsPage	 = new CUtilsPage;
}

CPrinterSettings::~CPrinterSettings()
{
	//Remove the other tabs
	delete InfoPage;
	delete EncodingPage;
	delete DriverPage1;
	delete DriverPage2;
	delete PrintPage;
	delete UtilsPage;
}

void CPrinterSettings::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BTN_OPENSESSION, OpenSessionBtn);
	DDX_Control(pDX, IDC_OPENSESSION_COMBO, OpenSessionCombo);
	DDX_Control(pDX, IDC_BTN_CLOSESESSION, CloseSessionBtn);
	DDX_Control(pDX, IDC_BTN_FEEDMOVECARD, FeedMoveBtn);
	DDX_Control(pDX, IDC_FEEDMOVE_COMBO, FeedMoveCombo);
	DDX_Control(pDX, IDC_BTN_MOVEFILM, MoveFilmBtn);
	DDX_Control(pDX, IDC_MOVEFILM_COMBO, MoveFilmCombo);
	DDX_Control(pDX, IDC_BTN_EJECTCARD, EjectCardBtn);
	DDX_Control(pDX, IDC_BTN_FLIPCARD, FlipCardBtn);
	DDX_Control(pDX, IDC_BTN_PRINTTESTCARD, TestCardBtn);
	DDX_Control(pDX, IDC_BTN_CLEANPRINTER, CleanBtn);
	DDX_Control(pDX, IDC_BTN_RESTARTPRINTER, RestartBtn);
	DDX_Control(pDX, IDC_BTN_GENERAL_CMD, GenCmdBtn);
	DDX_Control(pDX, IDC_GENERALMSG, GeneralMessage);
	DDX_Control(pDX, IDC_GENCOMMAND, GenCommandBox);
	DDX_Control(pDX, IDC_BTN_ERASECARD, EraseCardBtn);
	DDX_Control(pDX, IDC_ERASECARDAREA1, EraseAreaBotLX);
	DDX_Control(pDX, IDC_ERASECARDAREA2, EraseAreaBotLY);
	DDX_Control(pDX, IDC_ERASECARDAREA3, EraseAreaTopRX);
	DDX_Control(pDX, IDC_ERASECARDAREA4, EraseAreaTopRY);
	DDX_Control(pDX, IDC_BTN_ERASESPEED, EraseSpeedBtn);
	DDX_Control(pDX, IDC_ERASESPEED_COMBO, EraseSpeedCombo);
	DDX_Control(pDX, IDC_BTN_ERRORRESPONSE, ErrorRespBtn);
	DDX_Control(pDX, IDC_ERRORRESPONSE_COMBO, ErrorRespCombo);
	DDX_Control(pDX, IDC_EJECTMODE_COMBO, EjectModeCombo);
	DDX_Control(pDX, IDC_BTN_HORZEJECT, HorzEjectBtn);
	DDX_Control(pDX, IDC_SMARTOFFSET, SmartOffset);
	DDX_Control(pDX, IDC_SMART_OFFSET_SPIN, SmartOffset_Spin);
	DDX_Control(pDX, IDC_HORZEJECT_COMBO, HorzEjectCombo);
	DDX_Control(pDX, IDC_BTN_EJECTMODE, EjectModeBtn);
	DDX_Control(pDX, IDC_BTN_SMARTMODE, SmartModeBtn);
	DDX_Control(pDX, IDC_SMARTMODE_COMBO, SmartModeCombo);
	DDX_Control(pDX, IDC_BTN_SMARTOFFSET, SmartOffsetBtn);
	DDX_Control(pDX, IDC_BTN_IPSETTINGS, IPSettingsBtn);
	DDX_Control(pDX, IDC_IPADDRESSMODE_COMBO, IPModeCombo);
	DDX_Control(pDX, IDC_IPADDRESS, IPAddress);
	DDX_Control(pDX, IDC_IPADDR_SUBNET, IPSubnet);
	DDX_Control(pDX, IDC_IPADDR_GATEWAY, IPGateway);
	DDX_Control(pDX, IDC_BTN_HANDFEED, HandFeedBtn);
	DDX_Control(pDX, IDC_HANDFEED_COMBO, HandFeedCombo);
	DDX_Control(pDX, IDC_GETACTIONRADIO, PrinterGet);
	DDX_Control(pDX, IDC_SETACTIONRADIO, PrinterSet);
	DDX_Radio(pDX,   IDC_GETACTIONRADIO, PrinterAction);
	DDV_MinMaxInt(pDX, PrinterAction, 0, 1);
	DDX_Control(pDX, IDC_ERASECOUNT, EraseCount);
	DDX_Control(pDX, IDC_ERASECOUNT_SPIN, EraseCount_Spin);
	DDX_Control(pDX, IDC_IPADDR_LBL, IPAddressLabel);
	DDX_Control(pDX, IDC_IPSUBNET_LBL, IPSubnetLabel);
	DDX_Control(pDX, IDC_IPGATEWAY_LBL, IPGatewayLabel);
	DDX_Control(pDX, IDC_BTN_CARDLOCATION, CardLocationBtn);
	DDX_Control(pDX, IDC_GENCMDGROUPBOX, GenCmdGroupBox);
	DDX_Control(pDX, IDC_IPMODE_LABEL, IPModeLabel);
	DDX_Control(pDX, IDC_IPSETTINGS_GROUP, IPGroupBox);
}

BEGIN_MESSAGE_MAP(CPrinterSettings, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_OPENSESSION,     &CPrinterSettings::OnBnClickedBtnOpenSession)
	ON_BN_CLICKED(IDC_BTN_CLOSESESSION,    &CPrinterSettings::OnBnClickedBtnCloseSession)
	ON_BN_CLICKED(IDC_BTN_EJECTCARD,       &CPrinterSettings::OnBtnClickedEjectCard)
	ON_BN_CLICKED(IDC_BTN_FLIPCARD,        &CPrinterSettings::OnBnClickedBtnFlipCard)
	ON_BN_CLICKED(IDC_BTN_PRINTTESTCARD,   &CPrinterSettings::OnBnClickedBtnPrintTestCard)
	ON_BN_CLICKED(IDC_BTN_CLEANPRINTER,    &CPrinterSettings::OnBnClickedBtnCleanPrinter)
	ON_BN_CLICKED(IDC_BTN_RESTARTPRINTER,  &CPrinterSettings::OnBnClickedBtnRestartPrinter)
	ON_BN_CLICKED(IDC_BTN_GENERAL_CMD,     &CPrinterSettings::OnBtnClickedGeneralCmd)
	ON_BN_CLICKED(IDC_BTN_ERASECARD,       &CPrinterSettings::OnBnClickedBtnEraseCard)
	ON_BN_CLICKED(IDC_BTN_ERASESPEED,      &CPrinterSettings::OnBnClickedBtnEraseSpeed)
	ON_BN_CLICKED(IDC_BTN_ERRORRESPONSE,   &CPrinterSettings::OnBnClickedBtnErrorResponse)
	ON_BN_CLICKED(IDC_BTN_HORZEJECT,       &CPrinterSettings::OnBnClickedBtnHorzEject)
	ON_BN_CLICKED(IDC_BTN_EJECTMODE,       &CPrinterSettings::OnBnClickedBtnEjectMode)
	ON_BN_CLICKED(IDC_BTN_SMARTMODE,       &CPrinterSettings::OnBnClickedBtnSmartMode)
	ON_BN_CLICKED(IDC_BTN_SMARTOFFSET,     &CPrinterSettings::OnBnClickedBtnSmartOffset)
	ON_BN_CLICKED(IDC_GETACTIONRADIO,      &CPrinterSettings::OnBnClickedGetActionRadio)
	ON_BN_CLICKED(IDC_SETACTIONRADIO,      &CPrinterSettings::OnBnClickedSetActionRadio)
	ON_BN_CLICKED(IDC_BTN_IPSETTINGS,      &CPrinterSettings::OnBnClickedBtnIPSettings)
	ON_BN_CLICKED(IDC_BTN_HANDFEED,        &CPrinterSettings::OnBnClickedBtnHandFeed)
	ON_BN_CLICKED(IDC_BTN_GENERALMSG_CLR,  &CPrinterSettings::OnBnClickedBtnGeneralMsgClr)
	ON_BN_CLICKED(IDC_BTN_MOVEFILM,        &CPrinterSettings::OnBnClickedBtnMoveFilm)
	ON_BN_CLICKED(IDC_BTN_CARDLOCATION,    &CPrinterSettings::OnBnClickedBtnCardLocation)
	ON_BN_CLICKED(IDC_BTN_FEEDMOVECARD,    &CPrinterSettings::OnBnClickedBtnFeedMoveCard)
	ON_BN_CLICKED(IDC_BTN_MOVEFILM,        &CPrinterSettings::OnBnClickedBtnMoveFilm)
END_MESSAGE_MAP()

//#############################################################################

BOOL CPrinterSettings::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	Parent = (CMainSheet *)GetParent();
	Parent->PrinterType = ID_ENDURO;  //Default

	OpenSessionCombo.SetCurSel(0);

	CString temp;
	EraseAreaBotLX.SetWindowText(_T("0"));
	EraseAreaBotLY.SetWindowText(_T("0"));
	temp.Format(_T("%d"), Parent->MaxXCoord());
	EraseAreaTopRX.SetWindowText(temp);
	temp.Format(_T("%d"), Parent->MaxYCoord());
	EraseAreaTopRY.SetWindowText(temp);
	EraseCount.SetWindowText(_T("1"));
	EraseCount_Spin.SetRange(1, 499);

	ErrorRespCombo.SetCurSel(0);
	MoveFilmCombo.SetCurSel(0);

	SmartModeCombo.SetCurSel(0);
	SmartOffset.SetWindowText(_T("0"));
	SmartOffset_Spin.SetRange(0, 99);
	SmartOffset_Spin.SetRange32(0, 99000);
	EraseSpeedCombo.SetCurSel(0);
	EjectModeCombo.SetCurSel(0);
	HorzEjectCombo.SetCurSel(0);
	HandFeedCombo.SetCurSel(0);

	PrinterAction = 0;

	//Get the current filename
    TCHAR pFileName[MAX_PATH];
	if (GetModuleFileName(NULL, pFileName, MAX_PATH) > 0)
	{
		// Get the file version info size
		DWORD dwSize = GetFileVersionInfoSize(pFileName, NULL);
		if (dwSize != 0)
		{
			// Get the Version Info
			BYTE *pVersionInfo = new BYTE[dwSize];
			if (GetFileVersionInfo(pFileName, 0, dwSize, pVersionInfo))
			{
				//Query the specific Version information
				VS_FIXEDFILEINFO *pFileInfo = NULL;
				UINT pLenFileInfo = 0;
				if (VerQueryValue(pVersionInfo, _T("\\"), (LPVOID*) &pFileInfo, &pLenFileInfo))
				{
					//Output the application version number to the display
					temp.Format(_T("%d.%d.%d.%d"),
								HIWORD(pFileInfo->dwFileVersionMS),
								LOWORD(pFileInfo->dwFileVersionMS),
								HIWORD(pFileInfo->dwFileVersionLS),
								LOWORD(pFileInfo->dwFileVersionLS));
					AddGeneralMessage(_T("Demo Version: ") + temp);
					temp.Format(_T("%d"), SDKBits());
					AddGeneralMessage(temp + _T(" Bit SDK"));
					AddGeneralMessage(_T(""));
				}
			}

			delete [] pVersionInfo;
		}
	}

	return TRUE;  // return TRUE unless you set the focus to a control
}

//****************************************************************************

void CPrinterSettings::OnBnClickedGetActionRadio()
{
	EnableGetSetControls(FALSE);
}

void CPrinterSettings::OnBnClickedSetActionRadio()
{
	EnableGetSetControls(TRUE);
}

void CPrinterSettings::OnBnClickedBtnGeneralMsgClr()
{
	//Clear the message area
	GeneralMessage.SetWindowText(_T(""));
}

BOOL CPrinterSettings::ActionIsGet()
{
	//Test the 'Action' radio buttons
	return (PrinterAction == 0);
}

//****************************************************************************

void CPrinterSettings::ShowHideControls()
{
	BOOL bControl = (Parent->PrinterType == ID_GENERATION2);

    //Controls for Rio Pro 360
	MoveFilmBtn.ShowWindow(bControl);
	MoveFilmCombo.ShowWindow(bControl);
	CardLocationBtn.ShowWindow(bControl);

    //Controls for Enduro
	GenCmdGroupBox.ShowWindow(!bControl);
	GenCommandBox.ShowWindow(!bControl);
	GenCmdBtn.ShowWindow(!bControl);
	CleanBtn.ShowWindow(!bControl);
	SmartModeBtn.ShowWindow(!bControl);
	SmartModeCombo.ShowWindow(!bControl);
	HorzEjectBtn.ShowWindow(!bControl);
	HorzEjectCombo.ShowWindow(!bControl);
	EraseSpeedBtn.ShowWindow(!bControl);
	EraseSpeedCombo.ShowWindow(!bControl);
}

//****************************************************************************

void CPrinterSettings::EnableGetSetControls
(
	BOOL bControl
)
{
	//Enable/disable the Get/Set controls
	PrinterAction = bControl;

	SmartModeCombo.EnableWindow(bControl);
	EraseSpeedCombo.EnableWindow(bControl);
	HorzEjectCombo.EnableWindow(bControl);
	HandFeedCombo.EnableWindow(bControl);
	EjectModeCombo.EnableWindow(bControl);
	SmartOffset.EnableWindow(bControl);
	SmartOffset_Spin.EnableWindow(bControl);

	if (!ProntoPrinter())
	{
		IPModeCombo.EnableWindow(bControl);
		IPAddress.EnableWindow(bControl);
		IPSubnet.EnableWindow(bControl);
		IPGateway.EnableWindow(bControl);
	}
}

//****************************************************************************

void CPrinterSettings::EnableControls
(
	BOOL bControl
)
{
	//Enable/disable controls on the page
	MoveFilmBtn.EnableWindow(bControl);
	MoveFilmCombo.EnableWindow(bControl);
	CardLocationBtn.EnableWindow(bControl);
	GenCmdBtn.EnableWindow(bControl);
	GenCommandBox.EnableWindow(bControl);
	CleanBtn.EnableWindow(bControl);
	EraseSpeedBtn.EnableWindow(bControl);
	HorzEjectBtn.EnableWindow(bControl);
	SmartModeBtn.EnableWindow(bControl);

	FeedMoveBtn.EnableWindow(bControl);
	FeedMoveCombo.EnableWindow(bControl);
	EjectCardBtn.EnableWindow(bControl);
	FlipCardBtn.EnableWindow(bControl);
	TestCardBtn.EnableWindow(bControl);
	RestartBtn.EnableWindow(bControl);

	EraseAreaBotLX.EnableWindow(bControl);
	EraseAreaBotLY.EnableWindow(bControl);
	EraseAreaTopRX.EnableWindow(bControl);
	EraseAreaTopRY.EnableWindow(bControl);
	EraseCount.EnableWindow(bControl);
	EraseCardBtn.EnableWindow(bControl);

	ErrorRespBtn.EnableWindow(bControl);
	ErrorRespCombo.EnableWindow(bControl);

	PrinterGet.EnableWindow(bControl);
	PrinterSet.EnableWindow(bControl);
	HandFeedBtn.EnableWindow(bControl);
	EjectModeBtn.EnableWindow(bControl);
	EjectModeCombo.EnableWindow(bControl);
	SmartOffsetBtn.EnableWindow(bControl);
	IPSettingsBtn.EnableWindow(bControl);

	EnableGetSetControls(!ActionIsGet());

	if (bControl)
	{
		//Add other tabs
		Parent->AddPage(InfoPage);
		Parent->AddPage(EncodingPage);
		Parent->AddPage(DriverPage1);
		Parent->AddPage(DriverPage2);
		Parent->AddPage(PrintPage);
		Parent->AddPage(UtilsPage);
	}

	else
	{
		if (Parent->GetPageCount() > 1)
		{
			//Remove other tabs
			Parent->RemovePage(InfoPage);
			Parent->RemovePage(EncodingPage);
			Parent->RemovePage(DriverPage1);
			Parent->RemovePage(DriverPage2);
			Parent->RemovePage(PrintPage);
			Parent->RemovePage(UtilsPage);
		}
	}
}

//****************************************************************************

void CPrinterSettings::AddGeneralMessage
(
	CString pMessage
)
{
	Parent->AddString(&GeneralMessage, pMessage);
}

//****************************************************************************

BYTE CPrinterSettings::SDKBits()
{
	//Get the SDK function address
	PFNIDSDKBITS pFnSDKBits = (PFNIDSDKBITS)GetProcAddress(Parent->hLib, "ID_SDKBits");
	if (!pFnSDKBits)
	{
		FUNCTION_NOT_ACCESSED(SDKBits);
		return FALSE;
	}
	else
	{
		return (*pFnSDKBits)();
	}
}

//****************************************************************************

int CPrinterSettings::GetPrinterModel()
{
	//Get the SDK function address
	PFNIDPRNMODEL pFnPrnModel = (PFNIDPRNMODEL)GetProcAddress(Parent->hLib, "ID_PrinterModel");
	if (!pFnPrnModel)
	{
		FUNCTION_NOT_ACCESSED(ProntoPrinter);
		return FALSE;
	}
	else
	{
		//Check if base model is pronto - doesn't have ethernet
		int result = (*pFnPrnModel)(Parent->hSession);
		if (result == ID_ERROR)
		{
			return FALSE;
		}
		else
		{
			return result;
		}
	}
}

//****************************************************************************

BOOL CPrinterSettings::ProntoPrinter()
{
	if (Parent->PrinterType != ID_ENDURO)
	{
		return FALSE;
	}

	return ((Parent->PrinterModel & ID_MOD_PRONTO) != 0);
}

//****************************************************************************

BOOL CPrinterSettings::PrinterConnected()
{
	PFNIDSTATUS pFnPrinterStatus = (PFNIDSTATUS)GetProcAddress(Parent->hLib, "ID_PrinterStatus");
	if (!pFnPrinterStatus)
	{
		FUNCTION_NOT_ACCESSED(GetPrinterStatus);
	}

	else
	{
		//Call the SDK to get the printer status
		CString temp_string;
		switch ((*pFnPrinterStatus)(Parent->hSession))
		{
		case ID_STATUS_READY:	return true;
		case ID_STATUS_OFFLINE: temp_string = _T("Printer is offline");  break;
		case ID_STATUS_ERROR:   temp_string = _T("Printer is in error"); break;
		case ID_STATUS_BUSY:    temp_string = _T("Printer is busy");     break;
		}
		MessageBox(temp_string, MSGBOX_TITLE, MB_OK | MB_ICONINFORMATION );
	}

	return false;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnOpenSession()
{
	//Display the printer dialog
	CPrintDialog dlg(FALSE);
	dlg.m_pd.Flags &= ~(PD_DISABLEPRINTTOFILE | PD_HIDEPRINTTOFILE);
	if (dlg.DoModal() == IDOK)
	{
		CWaitCursor wait;
		int iEsc = ESC_IS_SDK_CAPABLE;

		PrintPage->PrinterDC    = dlg.GetPrinterDC();
		PrintPage->DeviceName   =
		DriverPage2->DeviceName = dlg.GetDeviceName();

		Parent->PrintToFile = ((dlg.m_pd.Flags & PD_PRINTTOFILE) != 0);

		//Check the selected printer is SDK capable
		int escRes = ExtEscape(dlg.GetPrinterDC(), QUERYESCSUPPORT, sizeof(iEsc), (LPCSTR)&iEsc, 0, NULL);
		if (escRes <= 0)
		{
			MessageBox(_T("OpenPrinter - Error"), MSGBOX_TITLE, MB_OK | MB_ICONSTOP);
		}

		else
		{
			//Get the SDK function address
			PFNIDOPEN pFnOpenSession = (PFNIDOPEN)GetProcAddress(Parent->hLib, "ID_OpenSession");
			if (!pFnOpenSession)
			{
				FUNCTION_NOT_ACCESSED(OpenSession);
			}

			else
			{
				//Start the SDK Session
				ID_RETURN SDKReturn = (*pFnOpenSession)(dlg.GetPrinterDC(), &Parent->hSession, (ID_CONFIG)OpenSessionCombo.GetCurSel());
				if (SDKReturn != ID_SUCCESS)
				{
					DISPLAY_ERROR(OpenSession, SDKReturn);
				}

				else
				{
					//Call the SDK to get the printer type, save it for use elsewhere
					PFNIDPRNTYPE pFnPrinterType = (PFNIDPRNTYPE)GetProcAddress(Parent->hLib, "ID_PrinterType");
					Parent->PrinterType = (ID_PRINTER)(*pFnPrinterType)(Parent->hSession);
					if ((Parent->PrinterType != ID_ENDURO)
					&&  (Parent->PrinterType != ID_GENERATION2))
					{
						MessageBox(_T("Invalid Printer - DTC Only"), MSGBOX_TITLE, MB_OK | MB_ICONSTOP);
						PFNIDCLOSE pFnCloseSession = (PFNIDCLOSE)GetProcAddress(Parent->hLib, "ID_CloseSession");
						(*pFnCloseSession)(Parent->hSession);
					}

					else
					{
						ShowHideControls();

						if (Parent->PrinterType == ID_GENERATION2)
						{
							CString temp;
							temp.Format(_T("%d"), Parent->MaxXCoord());
							EraseAreaTopRX.SetWindowText(temp);

							//Set up button and combo for Move Card
							FeedMoveBtn.SetWindowText(_T("MoveCard"));
							FeedMoveBtn.EnableWindow(TRUE);
							for (int i = FeedMoveCombo.GetCount() - 1; i >= 0; i--)
							{
							   FeedMoveCombo.DeleteString(i);
							}
							FeedMoveCombo.AddString(_T("Standby"));
							FeedMoveCombo.AddString(_T("Contact"));
							FeedMoveCombo.AddString(_T("Contactless"));
							FeedMoveCombo.AddString(_T("Flip"));
							FeedMoveCombo.AddString(_T("Eject"));
							FeedMoveCombo.AddString(_T("Initialise"));
							FeedMoveCombo.AddString(_T("Reject"));
							FeedMoveCombo.SetCurSel(0);
							FeedMoveCombo.EnableWindow(TRUE);

							if (!Parent->PrintToFile)
							{
								//Get Hand Feed status
								ID_HANDFEED HandFeed;
								GetHandFeed(&HandFeed);
							}
						}
						else
						{
							//Set up button and combo for Feed Card
							FeedMoveBtn.SetWindowText(_T("FeedCard"));
							FeedMoveBtn.EnableWindow(TRUE);
							for (int i = FeedMoveCombo.GetCount() - 1; i >= 0; i--)
							{
							   FeedMoveCombo.DeleteString(i);
							}
							FeedMoveCombo.AddString(_T("Contact"));
							FeedMoveCombo.AddString(_T("Contactless"));
							FeedMoveCombo.SetCurSel(0);
							FeedMoveCombo.EnableWindow(TRUE);

							if (!Parent->PrintToFile)
							{
								//Get the SDK function address
								PFNIDPRINTERINFO pFnPrinterInfo = (PFNIDPRINTERINFO)GetProcAddress(Parent->hLib, "ID_PrinterInfo");
								if (!pFnPrinterInfo)
								{
									FUNCTION_NOT_ACCESSED(InitialisePerPrinter-GetPrinterInfo);
								}

								else
								{
									//Get Printer Info to initialise the controls
									PRINTER_INFO PrinterInfo;
									ID_RETURN SDKReturn = (*pFnPrinterInfo)(Parent->hSession, &PrinterInfo);
									if (SDKReturn != ID_SUCCESS)
									{
										DISPLAY_ERROR(Open-GetPrinterInfo, SDKReturn);
									}

									else
									{
										//Update the various controls on the page
										if (PrinterInfo.iBitFields & ID_MASK_ENCODEPLATEN)
											SetSmartModeBox(ID_SMART_PLATEN);
										else if (PrinterInfo.iBitFields & ID_MASK_ENCODEXLI)
											SetSmartModeBox(ID_SMART_XLI);
										else
											SetSmartModeBox(ID_SMART_DEFAULT);
										SetHandFeedBox(PrinterInfo.iHandFeed);
										SetEraseSpeedBox((PrinterInfo.iBitFields & ID_MASK_ERASESPEED) ? ID_ERASE_THOROUGH : ID_ERASE_QUICK);
										SetEjectModeBox((PrinterInfo.iBitFields  & ID_MASK_EJECTMODE) ? ID_EJECT_ON : ID_EJECT_OFF);
										SetHorzEjectBox((PrinterInfo.iBitFields  & ID_MASK_HORZEJECT) ? ID_HORZEJECT_ON : ID_HORZEJECT_OFF);
										SetSmartOffsetBox(PrinterInfo.iSmartOffset);
									}
								}
							}
						}

						Parent->PrinterModel = GetPrinterModel();
						if (ProntoPrinter())
						{
							IPSettingsBtn.ShowWindow(false);
							IPModeCombo.ShowWindow(false);
							IPAddress.ShowWindow(false);
							IPSubnet.ShowWindow(false);
							IPGateway.ShowWindow(false);
							IPGroupBox.ShowWindow(false);
							IPModeLabel.ShowWindow(false);
							IPAddressLabel.ShowWindow(false);
							IPSubnetLabel.ShowWindow(false);
							IPGatewayLabel.ShowWindow(false);
						}
						

						else if (!Parent->PrintToFile 
							&& GetConnectionType() != ID_PORT_USB)
						{
							IPDATA IPData;
							GetIPSettings(&IPData);
							IPModeCombo.EnableWindow(true);
							IPAddress.EnableWindow(true);
							IPSubnet.EnableWindow(true);
							IPGateway.EnableWindow(true);
						}

						//Update the display to show the Session is open
						OpenSessionBtn.ShowWindow(FALSE);
						OpenSessionCombo.ShowWindow(FALSE);
						CloseSessionBtn.ShowWindow(TRUE);

						EnableControls(TRUE);
					}
				}
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnCloseSession()
{
	//Get the SDK function address
	PFNIDCLOSE pFnCloseSession = (PFNIDCLOSE)GetProcAddress(Parent->hLib, "ID_CloseSession");
	if (!pFnCloseSession)
	{
		FUNCTION_NOT_ACCESSED(CloseSession);
	}

	else
	{
		// Clean up.
		OpenSessionBtn.ShowWindow(TRUE);
		OpenSessionCombo.ShowWindow(TRUE);
		CloseSessionBtn.ShowWindow(FALSE);
		EnableControls(FALSE);
		EnableGetSetControls(FALSE);

		ID_RETURN SDKReturn = (*pFnCloseSession)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(CloseSession, SDKReturn);
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnErrorResponse()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDRESPONSE pFnErrorResponse = (PFNIDRESPONSE)GetProcAddress(Parent->hLib, "ID_ErrorResponse");
	if (!pFnErrorResponse)
	{
		FUNCTION_NOT_ACCESSED(ErrorResponse);
	}

	else
	{
		//Call SDK to send the selected Error Response to the printer
		ID_RETURN SDKReturn = (*pFnErrorResponse)(Parent->hSession, (ID_RESPONSE)ErrorRespCombo.GetCurSel());
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(ErrorResponse, SDKReturn);
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnFeedMoveCard()
{
	if (Parent->PrinterType == ID_GENERATION2)
	{
		MoveCard();
	}
	else
	{
		FeedCard();
	}
}

//****************************************************************************

void CPrinterSettings::FeedCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDFEED pFnFeedCard = (PFNIDFEED)GetProcAddress(Parent->hLib, "ID_FeedCard");
	if (!pFnFeedCard)
	{
		FUNCTION_NOT_ACCESSED(FeedCard);
	}

	else
	{
		//Call SDK to Feed a Card
		ID_RETURN SDKReturn = (*pFnFeedCard)(Parent->hSession, (ID_FEED)FeedMoveCombo.GetCurSel(), 0);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(FeedCard, SDKReturn);
		}

		else
		{
			//Wait for the card to be fed into place
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(FeedCardWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::MoveCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDMOVE pFnMoveCard = (PFNIDMOVE)GetProcAddress(Parent->hLib, "ID_MoveCard");
	if (!pFnMoveCard)
	{
		FUNCTION_NOT_ACCESSED(MoveCard);
	}

	else
	{
		//Call SDK to Move a Card
		ID_CARD_POSITION location;
		switch (FeedMoveCombo.GetCurSel())
		{
		case 0: location = ID_STANDBY;             break;
		case 1: location = ID_CONTACT_ENCODER;     break;
		case 2: location = ID_CONTACTLESS_ENCODER; break;
		case 3: location = ID_ROTATE;              break;
		case 4: location = ID_EJECT;               break;
		case 5: location = ID_INITIALISE;          break;
		case 6: location = ID_REJECT;              break;
		}

		ID_RETURN SDKReturn = (*pFnMoveCard)(Parent->hSession, location);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(MoveCard, SDKReturn);
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnMoveFilm()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDMOVEFILM pFnMoveFilm = (PFNIDMOVEFILM)GetProcAddress(Parent->hLib, "ID_MoveFilm");
	if (!pFnMoveFilm)
	{
		FUNCTION_NOT_ACCESSED(MoveFilm);
	}

	else
	{
		//Call SDK to Move a Card
		ID_PANEL panel;
		switch (MoveFilmCombo.GetCurSel())
		{
		case 0: panel = ID_PANEL_INIT; break;
		case 1: panel = ID_PANEL_NEXT; break;
		case 2: panel = ID_PANEL_Y;    break;
		case 3: panel = ID_PANEL_M;    break;
		case 4: panel = ID_PANEL_C;    break;
		case 5: panel = ID_PANEL_K;    break;
		case 6: panel = ID_PANEL_O;    break;
		}

		ID_RETURN SDKReturn = (*pFnMoveFilm)(Parent->hSession, panel);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(MoveFilm, SDKReturn);
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBtnClickedEjectCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDEJECT pFnEjectCard = (PFNIDEJECT)GetProcAddress(Parent->hLib, "ID_EjectCard");
	if (!pFnEjectCard)
	{
		FUNCTION_NOT_ACCESSED(EjectCard);
	}

	else
	{
		//Call SDK to Eject the Card
		ID_RETURN SDKReturn = (*pFnEjectCard)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(EjectCard, SDKReturn);
		}

		else
		{
			//Wait for the card to be ejected
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(EjectCardWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnFlipCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDFLIP pFnFlipCard = (PFNIDFLIP)GetProcAddress(Parent->hLib, "ID_FlipCard");
	if (!pFnFlipCard)
	{
		FUNCTION_NOT_ACCESSED(FlipCard);
	}

	else
	{
		//Call SDK to Flip the Card
		ID_RETURN SDKReturn = (*pFnFlipCard)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(FlipCard, SDKReturn);
		}

		else
		{
			//Wait for the card to be flipped
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(FlipCardWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnCleanPrinter()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDCLEAN pFnCleanPrinter = (PFNIDCLEAN)GetProcAddress(Parent->hLib, "ID_CleanPrinter");
	if (!pFnCleanPrinter)
	{
		FUNCTION_NOT_ACCESSED(CleanPrinter);
	}

	else
	{
		//Call SDK to Clean the printer
		ID_RETURN SDKReturn = (*pFnCleanPrinter)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(CleanPrinter, SDKReturn);
		}

		else
		{
			//Wait for the clean cycle to be completed
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(CleanPrinterWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnRestartPrinter()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDRESTART pFnRestartPrinter = (PFNIDRESTART)GetProcAddress(Parent->hLib, "ID_RestartPrinter");
	if (!pFnRestartPrinter)
	{
		FUNCTION_NOT_ACCESSED(RestartPrinter);
	}

	else
	{
		//Call SDK to Restart the printer
		ID_RETURN SDKReturn = (*pFnRestartPrinter)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(RestartPrinter, SDKReturn);
		}

		else
		{
			//Wait for the printer to restart
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(RestartPrinterWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnPrintTestCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDPRINTTEST pFnPrintTestCard = (PFNIDPRINTTEST)GetProcAddress(Parent->hLib, "ID_PrintTestCard");
	if (!pFnPrintTestCard)
	{
		FUNCTION_NOT_ACCESSED(PrintTestCard);
	}

	else
	{
		ID_RETURN SDKReturn;
		
		if(Parent->PrinterType == ID_GENERATION2)
		{
			//Call SDK to Prepare to Print a Test Card
			PFNIDPREPARE pFnPrepare = (PFNIDPREPARE)GetProcAddress(Parent->hLib, "ID_PrepareForPrint");
			SDKReturn = (*pFnPrepare)(Parent->hSession);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(PrintTestCardPrepare, SDKReturn);
				return;
			}
		}

		//Call SDK to Print a Test Card
		SDKReturn = (*pFnPrintTestCard)(Parent->hSession);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(PrintTestCard, SDKReturn);
			return;
		}

		if(Parent->PrinterType == ID_GENERATION2)
		{
			PFNIDPRINTCOMP pFnComplete = (PFNIDPRINTCOMP)GetProcAddress(Parent->hLib, "ID_WaitPrintComplete");
			SDKReturn = (*pFnComplete)(Parent->hSession);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(PrintTestCardComplete, SDKReturn);
			}
		}
		else
		{
			//Wait for the test card to be printed
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(PrintTestCardWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnEraseCard()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDERASE pFnEraseCard = (PFNIDERASE)GetProcAddress(Parent->hLib, "ID_EraseCard");
	if (!pFnEraseCard)
	{
		FUNCTION_NOT_ACCESSED(EraseCard);
	}

	else
	{
		//Call SDK to do an Erase of a Rewritable Card
		CString	BotLX, BotLY, TopRX, TopRY, Count;
		EraseAreaBotLX.GetWindowText(BotLX);
		EraseAreaBotLY.GetWindowText(BotLY);
		EraseAreaTopRX.GetWindowText(TopRX);
		EraseAreaTopRY.GetWindowText(TopRY);
		EraseCount.GetWindowText(Count);

		ID_RETURN SDKReturn = (*pFnEraseCard)(Parent->hSession,
											  _ttoi(Count),
											  _ttoi(BotLX),
											  _ttoi(BotLY),
											  _ttoi(TopRX),
											  _ttoi(TopRY));
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(OnBnClickedBtnErasecard, SDKReturn);
		}

		else
		{
			//Wait for the erase to complete
			SDKReturn = Parent->WaitForPrinterToFinish();
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(OnBnClickedBtnErasecardWait, SDKReturn);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBtnClickedGeneralCmd()
{
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDGENERAL pFnGeneralCommand = (PFNIDGENERAL)GetProcAddress(Parent->hLib, IDFN_GENCOMMAND);
	if (!pFnGeneralCommand)
	{
		FUNCTION_NOT_ACCESSED(GeneralCommand);
	}

	else
	{
		//Call SDK to send the General Command
		CString strCmd;
		GenCommandBox.GetWindowText(strCmd);
		if (strCmd.GetLength() != 0)
		{
			ID_RETURN SDKReturn = (*pFnGeneralCommand)(Parent->hSession, strCmd.GetBuffer());
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(GeneralCommand, SDKReturn);
			}
		}
	}
}

//#############################################################################

void CPrinterSettings::HandFeedToMsgBox
(
	DWORD        HandFeed,
	ID_READWRITE Action
)
{
	//Update the message box with the Hand Feed status
	AddGeneralMessage(_T("HandFeed") + Parent->Separator(Action) + Parent->OnOffString(HandFeed));
	AddGeneralMessage(_T(""));
}

//****************************************************************************

void CPrinterSettings::SetHandFeedBox
(
	DWORD mode
)
{
	//Update the Hand Feed control
	HandFeedCombo.SetCurSel(mode);
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetHandFeed
(
	PID_HANDFEED HandFeed
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDHANDFEED pFnHandFeed = (PFNIDHANDFEED)GetProcAddress(Parent->hLib, "ID_HandFeed");
	if (!pFnHandFeed)
	{
		FUNCTION_NOT_ACCESSED(GetHandFeed);
	}

	else
	{
		// Call the SDK to read the Hand Feed status
		SDKReturn = (*pFnHandFeed)(Parent->hSession, ID_READ, HandFeed);
		if (SDKReturn == ID_SUCCESS)
		{
			SetHandFeedBox(*HandFeed);
		}
		else
		{
			DISPLAY_ERROR(GetHandFeed, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnHandFeed()
{
	CWaitCursor	wait;
	ID_HANDFEED mode;

	if (ActionIsGet())
	{
		//Get the Hand Feed status
		if (GetHandFeed(&mode) == ID_SUCCESS)
		{
			HandFeedToMsgBox(mode, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDHANDFEED pFnHandFeed = (PFNIDHANDFEED)GetProcAddress(Parent->hLib, "ID_HandFeed");
		if (!pFnHandFeed)
		{
			FUNCTION_NOT_ACCESSED(GetHandFeed);
		}

		else
		{
			//Get the selected Hand Feed Status
			mode = (ID_HANDFEED)HandFeedCombo.GetCurSel();

			//Call the SDK to update it
			int SDKReturn = (*pFnHandFeed)(Parent->hSession, ID_WRITE, &mode);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetHandFeed, SDKReturn);
			}
			else
			{
				AddGeneralMessage(_T("HandFeed -> ") + Parent->OnOffString(mode));
				AddGeneralMessage(_T(""));
			}
		}
	}
}

//#############################################################################

void CPrinterSettings::EjectModeToMsgBox
(
	ID_EJECTMODE Mode,
	ID_READWRITE Action
)
{
	//Update the message box with the Eject Mode status
	AddGeneralMessage(_T("EjectMode") + Parent->Separator(Action) + Parent->OnOffString(Mode));
	AddGeneralMessage(_T(""));
}

//****************************************************************************

void CPrinterSettings::SetEjectModeBox
(
	ID_EJECTMODE mode
)
{
	//Update the Eject Mode control
	EjectModeCombo.SetCurSel(mode);
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetEjectMode
(
	PID_EJECTMODE Mode
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDEJECTMODE pFnEjectMode = (PFNIDEJECTMODE)GetProcAddress(Parent->hLib, "ID_EjectMode");
	if (!pFnEjectMode)
	{
		FUNCTION_NOT_ACCESSED(GetEjectMode);
	}

	else
	{
		// Call the SDK to read the Eject Mode status
		SDKReturn = (*pFnEjectMode)(Parent->hSession, ID_READ, Mode);
		if (SDKReturn == ID_SUCCESS)
		{
			SetEjectModeBox(*Mode);
		}
		else
		{
			DISPLAY_ERROR(GetEjectMode, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnEjectMode()
{
	CWaitCursor wait;
	ID_EJECTMODE Mode;

	if (ActionIsGet())
	{
		//Get the Eject Mode status
		if (GetEjectMode(&Mode) == ID_SUCCESS)
		{
			EjectModeToMsgBox(Mode, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDEJECTMODE pFnEjectMode = (PFNIDEJECTMODE)GetProcAddress(Parent->hLib, "ID_EjectMode");
		if (!pFnEjectMode)
		{
			FUNCTION_NOT_ACCESSED(GetEjectMode);
		}

		else
		{
			//Get the selected Eject Mode status
			Mode = (ID_EJECTMODE)EjectModeCombo.GetCurSel();

			//Call the SDK to update it
			ID_RETURN SDKReturn = (*pFnEjectMode)(Parent->hSession, ID_WRITE, &Mode);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(GetEjectMode, SDKReturn);
			}
			else
			{
				//Update the message box
				EjectModeToMsgBox(Mode, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CPrinterSettings::HorzEjectToMsgBox
(
	ID_HORZEJECT HorzEject,
	ID_READWRITE Action
)
{
	//Update the message box with the Horizontal Eject status
	AddGeneralMessage(_T("HorzEject") + Parent->Separator(Action) + Parent->OnOffString(HorzEject));
	AddGeneralMessage(_T(""));
}

//****************************************************************************

void CPrinterSettings::SetHorzEjectBox
(
	ID_HORZEJECT HorzEject
)
{
	//Update the Horizontal Eject control
	HorzEjectCombo.SetCurSel(HorzEject);
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetHorzEjectMode
(
	PID_HORZEJECT Mode
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDHORZEJECT pFnHorzEject = (PFNIDHORZEJECT)GetProcAddress(Parent->hLib, "ID_HorzEject");
	if (!pFnHorzEject)
	{
		FUNCTION_NOT_ACCESSED(GetHorzEject);
	}

	else
	{
		// Call the SDK to read the Horizontal Eject mode status
		SDKReturn = (*pFnHorzEject)(Parent->hSession, ID_READ, Mode);
		if (SDKReturn == ID_SUCCESS)
		{
			SetHorzEjectBox(*Mode);
		}
		else
		{
			DISPLAY_ERROR(GetHorzEject, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnHorzEject()
{
	CWaitCursor wait;
	ID_HORZEJECT Mode;

	if (ActionIsGet())
	{
		//Get the Horizontal Eject Mode status
		if (GetHorzEjectMode(&Mode) == ID_SUCCESS)
		{
			HorzEjectToMsgBox(Mode, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDHORZEJECT pFnHorzEject = (PFNIDHORZEJECT)GetProcAddress(Parent->hLib, "ID_HorzEject");
		if (!pFnHorzEject)
		{
			FUNCTION_NOT_ACCESSED(SetHorzEject);
		}

		else
		{
			//Get the selected Horizontal Eject Mode status
			Mode = (ID_HORZEJECT)HorzEjectCombo.GetCurSel();

			//Call the SDK to update it
			ID_RETURN SDKReturn = (*pFnHorzEject)(Parent->hSession, ID_WRITE, &Mode);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetHorzEject, SDKReturn);
			}
			else
			{
				//Update the message box
				HorzEjectToMsgBox(Mode, ID_WRITE);
			}
		}
	}
}

//#############################################################################

CString CPrinterSettings::SmartModeString
(
	ID_SMARTMODE Mode
)
{
	switch (Mode)
	{
	case ID_SMART_DEFAULT: return _T("Default");
	case ID_SMART_PLATEN:  return _T("Platen");
	case ID_SMART_XLI:     return _T("XLI");
	default:               return _T("**Undefined**");
	}
}

//****************************************************************************

void CPrinterSettings::SmartModeToMsgBox
(
	ID_SMARTMODE Mode,
	ID_READWRITE Action
)
{
	//Update the message box with the Smart Mode status
	AddGeneralMessage(_T("SmartMode") + Parent->Separator(Action) + SmartModeString(Mode));
	AddGeneralMessage(_T(""));
}

//****************************************************************************

void CPrinterSettings::SetSmartModeBox
(
	ID_SMARTMODE mode
)
{
	//Update the Smart Mode control
	SmartModeCombo.SetCurSel(mode);
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetSmartMode
(
	PID_SMARTMODE Mode
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDSMARTMODE pFnSmartMode = (PFNIDSMARTMODE)GetProcAddress(Parent->hLib, "ID_SmartMode");
	if (!pFnSmartMode)
	{
		FUNCTION_NOT_ACCESSED(GetSmartMode);
	}

	else
	{
		// Call the SDK to read the Smart Mode status
		SDKReturn = (*pFnSmartMode)(Parent->hSession, ID_READ, Mode);
		if (SDKReturn == ID_SUCCESS)
		{
			SetSmartModeBox(*Mode);
		}
		else
		{
			DISPLAY_ERROR(GetSmartMode, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnSmartMode()
{
	CWaitCursor wait;
	ID_SMARTMODE Mode;

	if (ActionIsGet())
	{
		//get the Smart Mode status
		if (GetSmartMode(&Mode) == ID_SUCCESS)
		{
			SmartModeToMsgBox(Mode, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDSMARTMODE pFnSmartMode = (PFNIDSMARTMODE)GetProcAddress(Parent->hLib, "ID_SmartMode");
		if (!pFnSmartMode)
		{
			FUNCTION_NOT_ACCESSED(GetSmartMode);
		}

		else
		{
			//Get the selected Smart Mode status
			Mode = (ID_SMARTMODE)SmartModeCombo.GetCurSel();

			//Call the SDK to update it
			ID_RETURN SDKReturn = (*pFnSmartMode)(Parent->hSession, ID_WRITE, &Mode);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(GetSmartMode, SDKReturn);
			}
			else
			{
				//Update the message box
				AddGeneralMessage(_T("SmartMode -> ") + SmartModeString(Mode));
				AddGeneralMessage(_T(""));
			}
		}
	}
}

//#############################################################################

void CPrinterSettings::SmartOffsetToMsgBox
(
	int Offset,
	ID_READWRITE Action
)
{
	CString temp_string;

	//Update the message box with the Smart Offset status
	temp_string.Format(_T("%d"), Offset);
	AddGeneralMessage(_T("SmartOffset") + Parent->Separator(Action) + temp_string);
	AddGeneralMessage(_T(""));
}

//****************************************************************************

void CPrinterSettings::SetSmartOffsetBox
(
	int Offset
)
{
	CString temp_string;

	//Update the Smart Offset control
	temp_string.Format(_T("%d"), Offset);
	SmartOffset.SetWindowText(temp_string);
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetSmartOffset
(
	BYTE *Offset
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDSMARTOFFSET pFnSmartOffset = (PFNIDSMARTOFFSET)GetProcAddress(Parent->hLib, "ID_SmartOffset");
	if (!pFnSmartOffset)
	{
		FUNCTION_NOT_ACCESSED(GetSmartOffset);
	}

	else
	{
		// Call the SDK to read the Smart Mode Offset
		SDKReturn = (*pFnSmartOffset)(Parent->hSession, ID_READ, Offset);
		if (SDKReturn == ID_SUCCESS)
		{
			SetSmartOffsetBox(*Offset);
		}
		else
		{
			DISPLAY_ERROR(GetSmartOffset, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnSmartOffset()
{
	CWaitCursor wait;
	CString temp_string;
	BYTE Offset;

	if (ActionIsGet())
	{
		//Get the Smart Mode Offset
		if (GetSmartOffset(&Offset) == ID_SUCCESS)
		{
			SmartOffsetToMsgBox(Offset, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDSMARTOFFSET pFnSmartOffset = (PFNIDSMARTOFFSET)GetProcAddress(Parent->hLib, "ID_SmartOffset");
		if (!pFnSmartOffset)
		{
			FUNCTION_NOT_ACCESSED(SetSmartOffset);
		}

		else
		{
			//Get the selected Smart Mode Offset
			CString strCmd;
			SmartOffset.GetWindowText(strCmd);
			Offset = _ttoi(strCmd);

			//Call the SDK to update it
			ID_RETURN SDKReturn = (*pFnSmartOffset)(Parent->hSession, ID_WRITE, &Offset);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetSmartOffset, SDKReturn);
			}
			else
			{
				SmartOffsetToMsgBox(Offset, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CPrinterSettings::EraseSpeedToMsgBox
(
	ID_ERASESPEED Speed,
	ID_READWRITE Action
)
{
	//Update the message box with the Erase Speed status
	AddGeneralMessage(_T("EraseSpeed") + Parent->Separator(Action) + Parent->EraseSpeedString(Speed));
	AddGeneralMessage(_T(""));
}

//****************************************************************************

void CPrinterSettings::SetEraseSpeedBox
(
	ID_ERASESPEED speed
)
{
	//Update the Erase Speed control
	EraseSpeedCombo.SetCurSel(speed);
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetEraseSpeed
(
	PID_ERASESPEED Speed
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDERASESPEED pFnEraseSpeed = (PFNIDERASESPEED)GetProcAddress(Parent->hLib, "ID_EraseSpeed");
	if (!pFnEraseSpeed)
	{
		FUNCTION_NOT_ACCESSED(GetEraseSpeed);
	}

	else
	{
		// Call the SDK to read the Erase Speed status
		SDKReturn = (*pFnEraseSpeed)(Parent->hSession, ID_READ, Speed);
		if (SDKReturn == ID_SUCCESS)
		{
			SetEraseSpeedBox(*Speed);
		}
		else
		{
			DISPLAY_ERROR(GetEraseSpeed, SDKReturn);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnEraseSpeed()
{
	CWaitCursor wait;
	ID_ERASESPEED Speed;

	if (ActionIsGet())
	{
		//Get the Erase Speed status
		if (GetEraseSpeed(&Speed) == ID_SUCCESS)
		{
			EraseSpeedToMsgBox(Speed, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDERASESPEED pFnEraseSpeed = (PFNIDERASESPEED)GetProcAddress(Parent->hLib, "ID_EraseSpeed");
		if (!pFnEraseSpeed)
		{
			FUNCTION_NOT_ACCESSED(SetEraseSpeed);
		}

		else
		{
			//Get the selected Erase Speed status
			Speed = (ID_ERASESPEED)EraseSpeedCombo.GetCurSel();

			//Call the SDK to update it
			ID_RETURN SDKReturn = (*pFnEraseSpeed)(Parent->hSession, ID_WRITE, &Speed);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetEraseSpeed, SDKReturn);
			}
			else
			{
				//Update the message box
				EraseSpeedToMsgBox(Speed, ID_WRITE);
			}
		}
	}
}

//#############################################################################

void CPrinterSettings::IPSettingsToMsgBox
(
	PIPDATA      pIPData,
	ID_READWRITE Action
)
{
	CString sep = Parent->Separator(Action);

	//Update the message box with the IP Settings status
	CString temp_string = pIPData->IPAddressMode ? _T("Dynamic") : _T("Static");
	AddGeneralMessage(_T("Address Mode") + sep + temp_string);

	in_addr temp;
	temp.S_un.S_addr = htonl(pIPData->IPAddress);
	temp_string = inet_ntoa(temp);
	AddGeneralMessage(_T("IP Address") + sep + temp_string + "\n");

	temp.S_un.S_addr = htonl(pIPData->SubnetMask);
	temp_string = inet_ntoa(temp);
	AddGeneralMessage(_T("Subnet Mask") + sep + temp_string + "\n");

	temp.S_un.S_addr = htonl(pIPData->Gateway);
	temp_string = inet_ntoa(temp);
	AddGeneralMessage(_T("Gateway") + sep + temp_string + "\n");

	AddGeneralMessage(_T(""));
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetConnectionType() 
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get SDK function address
	PFNIDCONNECTION pFnConnection = (PFNIDCONNECTION)GetProcAddress(Parent->hLib, "ID_ConnectionType");
	if (!pFnConnection)
	{
		FUNCTION_NOT_ACCESSED(ConnectionType);
	}

	else
	{
		//Call the SDK to get the connection type
		int SDKReturn = (*pFnConnection)(Parent->hSession);
		
	}
	return SDKReturn;
}

//****************************************************************************

ID_RETURN CPrinterSettings::GetIPSettings
(
	PIPDATA pIPData
)
{
	ID_RETURN SDKReturn = ID_ERROR;

	//Get the SDK function address
	PFNIDIPSETTINGS pFnIPSettings = (PFNIDIPSETTINGS)GetProcAddress(Parent->hLib, "ID_IPSettings");
	if (!pFnIPSettings)
	{
		FUNCTION_NOT_ACCESSED(GetIPSettings);
	}

	else
	{
		// Call the SDK to read the IP Settings
		SDKReturn = (*pFnIPSettings)(Parent->hSession, ID_READ, pIPData);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(GetIPSettings, SDKReturn);
		}
		else
		{
			//Update the IP Settings controls
			IPModeCombo.SetCurSel(pIPData->IPAddressMode);

			in_addr temp;
			temp.S_un.S_addr = ntohl(pIPData->IPAddress);
			IPAddress.SetAddress(temp.S_un.S_un_b.s_b1,
								 temp.S_un.S_un_b.s_b2,
								 temp.S_un.S_un_b.s_b3,
								 temp.S_un.S_un_b.s_b4);
			temp.S_un.S_addr = ntohl(pIPData->SubnetMask);
			IPSubnet.SetAddress(temp.S_un.S_un_b.s_b1,
								temp.S_un.S_un_b.s_b2,
								temp.S_un.S_un_b.s_b3,
								temp.S_un.S_un_b.s_b4);
			temp.S_un.S_addr = ntohl(pIPData->Gateway);
			IPGateway.SetAddress(temp.S_un.S_un_b.s_b1,
								 temp.S_un.S_un_b.s_b2,
								 temp.S_un.S_un_b.s_b3,
								 temp.S_un.S_un_b.s_b4);
		}
	}

	return SDKReturn;
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnIPSettings()
{
	IPDATA IPData = {};
	CWaitCursor wait;

	if (ActionIsGet())
	{
		//Get the ethernet IP settings
		if (GetIPSettings(&IPData) == ID_SUCCESS)
		{
			IPSettingsToMsgBox(&IPData, ID_READ);
		}
	}

	else
	{
		//Get the SDK function address
		PFNIDIPSETTINGS pFnIPSettings = (PFNIDIPSETTINGS)GetProcAddress(Parent->hLib, "ID_IPSettings");
		if (!pFnIPSettings)
		{
			FUNCTION_NOT_ACCESSED(SetIPSettings);
		}

		else
		{
			//Get the selected ethernet IP settings
			BYTE add1, add2, add3, add4;
			char addr_string[20];

			IPData.IPAddressMode = IPModeCombo.GetCurSel() ? ID_DYNAMIC : ID_STATIC;

			IPAddress.GetAddress(add1, add2, add3, add4);
			sprintf_s(addr_string, sizeof(addr_string), "%d.%d.%d.%d", add1, add2, add3, add4);
 			IPData.IPAddress = htonl(inet_addr(addr_string));

			IPSubnet.GetAddress(add1, add2, add3, add4);
			sprintf_s(addr_string, sizeof(addr_string), "%d.%d.%d.%d", add1, add2, add3, add4);
			IPData.SubnetMask = htonl(inet_addr(addr_string));

			IPGateway.GetAddress(add1, add2, add3, add4);
			sprintf_s(addr_string, sizeof(addr_string), "%d.%d.%d.%d", add1, add2, add3, add4);
			IPData.Gateway = htonl(inet_addr(addr_string));

			//Call the SDK to update them
			ID_RETURN SDKReturn = (*pFnIPSettings)(Parent->hSession, ID_WRITE, &IPData);
			if (SDKReturn != ID_SUCCESS)
			{
				DISPLAY_ERROR(SetIPSettings, SDKReturn);
			}
			else
			{
				//Update the message box
				IPSettingsToMsgBox(&IPData, ID_WRITE);
			}
		}
	}
}

//****************************************************************************

void CPrinterSettings::OnBnClickedBtnCardLocation()
{
	ID_LOCATION location;
	CWaitCursor wait;

	//Get the SDK function address
	PFNIDLOCATION pFnCardLocation = (PFNIDLOCATION)GetProcAddress(Parent->hLib, "ID_CardLocation");
	if (!pFnCardLocation)
	{
		FUNCTION_NOT_ACCESSED(CardLocation);
	}

	else
	{
		ID_RETURN SDKReturn = (*pFnCardLocation)(Parent->hSession, &location);
		if (SDKReturn != ID_SUCCESS)
		{
			DISPLAY_ERROR(CardLocation, SDKReturn);
		}

		else
		{
			CString temp_string = _T("Card Location: ");
			switch (location)
			{
			case ID_UNKNOWN:     AddGeneralMessage(temp_string + _T("Unknown")); break;
			case ID_NO_CARD:     AddGeneralMessage(temp_string + _T("No Card")); break;
			case ID_PRINT_READY: AddGeneralMessage(temp_string + _T("Standby")); break;
			case ID_ENCODER:     AddGeneralMessage(temp_string + _T("Encoder")); break;
			default:             AddGeneralMessage(temp_string + _T("?????")); break;
			}
			AddGeneralMessage(_T(""));
		}
	}
}
